<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print SP-MPT - {{ $spSipt->nomor_surat }}</title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 10pt;
            line-height: 1.5;
            color: #000;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 15mm 20mm;
            margin: 0 auto;
            background: white;
            page-break-after: always;
        }

        .page:last-child {
            page-break-after: auto;
        }

        /* Page 1 - Cover */
        .cover-page {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            border: 3px double #000;
            padding: 30mm 20mm;
            position: relative;
        }

        .cover-content {
            text-align: center;
            width: 100%;
        }

        .logo-container {
            margin-bottom: 40px;
        }

        .logo-container img {
            width: 40%;
        }

        .cover-title {
            font-size: 20pt;
            font-weight: bold;
            text-align: center;
            margin-top: 60px;
            line-height: 1.8;
        }

        /* Page 2 & 3 - Surat Pernyataan */
        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header-logo {
            width: 80px;
            height: 90px;
            margin: 0 auto 10px;
        }

        .document-title {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        .document-number {
            text-align: center;
            margin-bottom: 25px;
        }

        .content {
            text-align: justify;
            line-height: 1.6;
        }

        .person-data {
            margin-left: 40px;
            margin-bottom: 15px;
        }

        .person-data table {
            width: 100%;
        }

        .person-data td {
            padding: 2px 0;
            vertical-align: top;
        }

        .person-data td:first-child {
            width: 180px;
        }

        .person-data td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .land-data {
            margin-left: 60px;
            margin-bottom: 15px;
        }

        .land-data table {
            width: 100%;
        }

        .land-data td {
            padding: 2px 0;
            vertical-align: top;
        }

        .land-data td:first-child {
            width: 160px;
        }

        .land-data td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .guarantee-list {
            margin-left: 60px;
            margin-bottom: 15px;
        }

        .guarantee-list ol {
            list-style-type: lower-alpha;
            padding-left: 20px;
        }

        .guarantee-list li {
            margin-bottom: 5px;
            text-align: justify;
        }

        .signature-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .signature-box {
            text-align: center;
            width: 200px;
        }

        .signature-title {
            margin-bottom: 80px;
            font-weight: bold;
        }

        .signature-name {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        .witness-section {
            margin-top: 30px;
        }

        .witness-box {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .witness-item {
            text-align: center;
            width: 200px;
        }

        .camat-section {
            margin-top: 30px;
            text-align: justify;
            margin-bottom: 30px;
        }

        .camat-signature {
            text-align: right;
            width: 250px;
            float: right;
        }

        .camat-date {
            margin-bottom: 5px;
        }

        .camat-title {
            margin-bottom: 80px;
        }

        .camat-name {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        .materai {
            position: absolute;
            bottom: 20mm;
            left: 20mm;
            font-weight: bold;
        }

        /* Page 4 - Sket Gambar */
        .sket-header {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .map-container {
            border: 2px solid #000;
            height: 400px;
            position: relative;
            margin-bottom: 0;
        }

        .compass {
            position: absolute;
            top: 20px;
            right: 30px;
            width: 80px;
            height: 80px;
        }

        .compass img {
            width: 100%;
            height: 100%;
        }

        .map-area {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 60%;
            height: 50%;
            background: #f0f0f0;
        }

        .map-area img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .boundary-info {
            border: 2px solid #000;
            border-top: none;
            display: flex;
        }

        .boundary-table {
            flex: 1;
            border-right: 2px solid #000;
        }

        .boundary-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .boundary-table td {
            padding: 5px 10px;
            border-bottom: 1px solid #000;
            font-size: 9pt;
        }

        .boundary-table td:first-child {
            width: 80px;
            font-weight: bold;
        }

        .boundary-table td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .coordinate-section {
            margin-top: 10px;
            border-top: 1px solid #000;
            padding-top: 10px;
        }

        .coordinate-section h4 {
            font-weight: bold;
            margin-bottom: 10px;
            padding-left: 10px;
        }

        .coordinate-table td {
            padding: 2px 10px;
            font-size: 8pt;
        }

        .coordinate-table td:first-child {
            width: 60px;
            font-weight: bold;
        }

        .boundary-signature {
            flex: 1;
            padding: 20px;
            text-align: center;
        }

        @media print {
            body {
                margin: 0;
            }
            .page {
                margin: 0;
                border: initial;
                page-break-after: always;
            }
        }
    </style>
</head>
<body>
    <!-- Page 1: Cover -->
    <div class="page">
        <div class="cover-page">
            <div class="cover-content">
                <div class="logo-container">
                    <img src="{{ asset('images/logo-berau.png') }}" alt="Logo Kabupaten Berau">
                </div>

                <div class="cover-title">
                    SURAT PERNYATAAN<br>
                    MELEPASKAN PENGUASAAN ATAS TANAH<br><br>
                    Nomor : {{ $spSipt->nomor_surat ?? '.....................................................' }}<br>
                    Tahun : {{ date('Y') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Page 2: Surat Pernyataan Part 1 -->
    <div class="page">
        <div class="document-title">SURAT PERNYATAAN MELEPASKAN PENGUASAAN ATAS TANAH</div>
        <div class="document-number">Nomor : {{ $spSipt->nomor_surat ?? '.........................................................................' }}</div>

        <div class="content">
            <p>Yang bertanda tangan dibawah ini :</p>

            <p style="margin-top: 15px;"><strong>I.</strong></p>
            <div class="person-data">
                <table>
                    <tr>
                        <td>Nama</td>
                        <td>:</td>
                        <td>{{ $spSipt->pemohon_nama }}</td>
                    </tr>
                    <tr>
                        <td>Tempat/Tanggal Lahir</td>
                        <td>:</td>
                        <td>{{ $spSipt->pemohon_tempat_lahir ?? '.......................' }}, {{ $spSipt->pemohon_tanggal_lahir ? \Carbon\Carbon::parse($spSipt->pemohon_tanggal_lahir)->format('d/m/Y') : '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>Nomor KTP</td>
                        <td>:</td>
                        <td>{{ $spSipt->pemohon_nik }}</td>
                    </tr>
                    <tr>
                        <td>Pekerjaan</td>
                        <td>:</td>
                        <td>{{ $spSipt->pemohon_pekerjaan ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td>{{ $spSipt->pemohon_alamat }}</td>
                    </tr>
                </table>
            </div>

            <p>Dalam hal ini bertindak untuk dan atas nama diri sendiri, selanjutnya disebut sebagai <strong>PIHAK PERTAMA</strong> yang melepaskan</p>

            <p style="margin-top: 15px;"><strong>II.</strong></p>
            <div class="person-data">
                <table>
                    <tr>
                        <td>Nama</td>
                        <td>:</td>
                        <td>{{ $spSipt->terlapor_nama ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>Tempat/Tanggal Lahir</td>
                        <td>:</td>
                        <td>{{ $spSipt->terlapor_tempat_lahir ?? '.......................' }}, {{ $spSipt->terlapor_tanggal_lahir ? \Carbon\Carbon::parse($spSipt->terlapor_tanggal_lahir)->format('d/m/Y') : '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>Nomor KTP</td>
                        <td>:</td>
                        <td>{{ $spSipt->terlapor_nik ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>Pekerjaan</td>
                        <td>:</td>
                        <td>{{ $spSipt->terlapor_pekerjaan ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td>{{ $spSipt->terlapor_alamat ?? '.......................' }}</td>
                    </tr>
                </table>
            </div>

            <p>Dalam hal ini bertindak untuk meyatakan dan atas nama diri sendiri selanjutnya disebut sebagai <strong>PIHAK KEDUA</strong> yang menerima pelepasan.</p>

            <p style="margin-top: 15px;"><strong>PIHAK PERTAMA</strong> dengan ini menyatakan dihadapan {{ $spSipt->ketua_rt ?? '.....................................................' }} dengan disaksikan oleh :</p>

            <div style="margin-left: 20px; margin-bottom: 15px;">
                <p>a. Ketua RT. {{ $spSipt->nama_rt ?? '.............................................................................................' }}</p>
                <p>b. Kepala Kampung : {{ $spSipt->kampung->nama_kampung ?? '..............................................................................................' }}</p>
            </div>

            <p>Hal-hal sebagai berikut :</p>

            <p style="margin-top: 15px;"><strong>1.</strong> <strong>PIHAK PERTAMA</strong> dengan ini melepaskan penguasaan atas tanah tersebut kepada <strong>PIHAK KEDUA</strong> yang terletak di :</p>

            <div class="land-data">
                <table>
                    <tr>
                        <td>a. Lokasi Tanah/RT</td>
                        <td>:</td>
                        <td>{{ $spSipt->lokasi_tanah_rt ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>b. Kampung</td>
                        <td>:</td>
                        <td>{{ $spSipt->kampung->nama_kampung ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>c. Kecamatan</td>
                        <td>:</td>
                        <td>{{ $spSipt->kecamatan->nama_kecamatan ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td>d. Ukuran Tanah</td>
                        <td>:</td>
                        <td>± {{ $spSipt->luas_terukur ?? '…………………' }} M²</td>
                    </tr>
                    <tr>
                        <td>e. Batas-Batas Tanah</td>
                        <td>:</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Utara</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_utara ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Timur</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_timur ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Selatan</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_selatan ?? '.......................' }}</td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Barat</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_barat ?? '.......................' }}</td>
                    </tr>
                </table>
            </div>

            <p style="text-align: justify;">Sehingga dengan demikian tanah tersebut menjadi tanah yang langsung dikuasai oleh <strong>PIHAK PERTAMA</strong> dan dilepaskan penguasaan atas tanah ini dilakukan semata-mata untuk kepentingan <strong>PIHAK KEDUA</strong>, dengan demikian <strong>PIHAK KEDUA</strong> dapat mengajukan permohonan sesuatu hak atas tanah yang akan di daftarkan atas namanya.</p>
        </div>
    </div>

    <!-- Page 3: Surat Pernyataan Part 2 -->
    <div class="page">
        <div class="content" style="margin-top: 0;">
            <p><strong>2.</strong> Bidang Tanah diperoleh <strong>PIHAK PERTAMA</strong> berdasarkan :</p>

            <div style="margin-left: 40px; margin-bottom: 15px;">
                <p>a. Bukti Kwitansi Pembelian, Tanggal {{ $spSipt->tanggal_sertifikat ? \Carbon\Carbon::parse($spSipt->tanggal_sertifikat)->format('d/m/Y') : '………………………………' }}</p>
                <p>b. Surat Keterangan Penguasaan dan Pemilikan Bangunan/Tanaman Diatas Tanah Negara Nomor : {{ $spSipt->nomor_tanggal_surat_penguasaan_tanah ?? '……………………' }}</p>
                <p>c. Sket Tanah keseluruhan/global</p>
            </div>

            <p><strong>3.</strong> Bidang tanah dipergunakan <strong>PIHAK PERTAMA</strong> untuk {{ $spSipt->peruntukan_bidang_tanah ?? 'Perkebunan' }}</p>

            <p><strong>4.</strong> Uang ganti kerugian/santunan untuk melepaskan penguasaan atas tanah pada angka 1 (satu) tersebut diatas telah dilepaskan dan ditetapkan oleh kedua belah pihak, <strong>PIHAK PERTAMA</strong> dan <strong>PIHAK KEDUA</strong> sebesar Rp. {{ $spSipt->uang_ganti_kerugian ?? '……………………..' }},- ( ……………………………………………………………………………………………… ), dan telah diterima oleh <strong>PIHAK PERTAMA</strong>. Surat Pernyataan ini berlaku pula sebagai "Kwitansi tanda terima pembayaran" termasuk juga penyerahan tanah tersebut dalam keadaan Kosong, dalam artian tidak dihuni atau digarap oleh siapapun.</p>

            <p><strong>5.</strong> <strong>PIHAK PERTAMA</strong> menjamin kepada <strong>PIHAK KEDUA</strong> bahwa :</p>

            <div class="guarantee-list">
                <ol>
                    <li>Tidak ada yang berhak dan berwenang untuk melakukan pelepasan penguasaan atas tanah tersebut kecuali <strong>PIHAK PERTAMA</strong> ;</li>
                    <li>Tanah tersebut tidak dalam keadaan sitaan dan tidak juga tersangkut dalam suatu sengketa atau perkara di Pengadilan ;</li>
                    <li>Tanah tersebut tidak dijaminkan atau di bebankan dengan hak dan tanggung dengan cara apapun juga kepada pihak lain ;</li>
                    <li>Tanah tersebut belum pernah diserahkan dengan cara apapun juga kepada pihak lain ;</li>
                    <li>Tanah tersebut tidak ada masalah dengan Batas ;</li>
                    <li>Tidak ada pihak lain yang turut mempunyai atas tanah tersebut ;</li>
                </ol>
            </div>

            <p><strong>6.</strong> <strong>PIHAK PERTAMA</strong> menjamin kepada <strong>PIHAK KEDUA</strong> baik sekarang maupun dikemudian hari bahwa <strong>PIHAK KEDUA</strong> tidak akan mendapatkan tuntutan atau gugatan dari siapapun juga mengenai Tanah tersebut dari segala tuntutan maupun gugatan adalah sepenuhnya menjadi tanggung jawab <strong>PIHAK PERTAMA</strong>, dan Pemerintah bebas dari segala tuntutan yang diajukan pihak siapapun juga.</p>

            <p><strong>7.</strong> Semua pajak termasuk PBB dan lain-lain kewajiban yang berkenaan dengan tanah tersebut, sepenuhnya menjadi tanggung jawab <strong>PIHAK PERTAMA</strong>, sampai dengan hari ini dan tanggal dibuatnya Surat Pernyataan ini.</p>

            <p><strong>8.</strong> <strong>PIHAK PERTAMA</strong> meyerahkan semua surat-surat yang berhubungan dengan pemilikan tanah tersebut kepada <strong>PIHAK KEDUA</strong> dan dengan demikian surat-surat tersebut tidak berlaku lagi bagi kepentingan <strong>PIHAK PERTAMA</strong>.</p>

            <div class="signature-section">
                <div class="signature-box">
                    <div class="signature-title">PIHAK KEDUA<br>Yang Menerima Pelepasan</div>
                    <div class="signature-name">{{ $spSipt->terlapor_nama ?? '________________________________________' }}</div>
                </div>

                <div class="signature-box">
                    <div class="signature-title">PIHAK PERTAMA<br>Yang Melepaskan</div>
                    <div class="signature-name">{{ $spSipt->pemohon_nama ?? '_________________________________________' }}</div>
                </div>
            </div>

            <div style="clear: both;"></div>

            <div class="witness-section">
                <p><strong>Para Saksi :</strong></p>
                <div class="witness-box">
                    <div class="witness-item">
                        <p>1. Ketua RT. {{ $spSipt->nama_rt ?? '..................................................' }}</p>
                        <br><br><br>
                        <p>_______________________________________</p>
                    </div>

                    <div class="witness-item">
                        <p>2. Kepala Kampung {{ $spSipt->kampung->nama_kampung ?? '..........................................' }}</p>
                        <br><br><br>
                        <p>_________________________________________</p>
                    </div>
                </div>
            </div>

            <div class="camat-section">
                <p>Saya Camat {{ $spSipt->kecamatan->nama_kecamatan ?? 'Biduk-Biduk' }} mengetahui dan telah menjelaskan isi surat pernyataan ini kepada <strong>PIHAK PERTAMA</strong> dan <strong>PIHAK KEDUA</strong> yang saya kenal, setelah nama kedua belah pihak menandatangani/membubuhkan Cap jempol diatas surat pernyataan ini dihadapan saya Camat {{ $spSipt->kecamatan->nama_kecamatan ?? 'Biduk-Biduk' }} dan didaftarkan dalam daftar Nomor : {{ $spSipt->nomor_surat ?? '.......................................................................................' }}</p>

                <div class="camat-signature">
                    <div class="camat-date">{{ $spSipt->lokasi_kota ?? 'Berau' }}, {{ \Carbon\Carbon::now()->format('d F Y') }}</div>
                    <div class="camat-title">Camat,</div>
                    <div class="camat-name">........................................................</div>
                    <div>NIP. ……………………………………………..……</div>
                </div>
            </div>

            <div style="clear: both;"></div>

            <div class="materai">
                <strong>Materai Rp. 10.000</strong>
            </div>
        </div>
    </div>

    <!-- Page 4: Sket Gambar -->
    <div class="page">
        <div class="sket-header">SKET/GAMBAR KASAR TANAH</div>

        <div class="map-container">
            <div class="compass">
                <img src="{{ asset('images/mata angin.png') }}" alt="Kompas">
            </div>

            <div class="map-area">
                @if($spSipt->map_image_data || $spSipt->map_image)
                    @if(strpos($spSipt->map_image_data ?? '', 'data:image') === 0)
                        <img src="{{ $spSipt->map_image_data }}" alt="Peta Tanah">
                    @elseif($spSipt->map_image)
                        <img src="{{ Storage::url($spSipt->map_image) }}" alt="Peta Tanah">
                    @endif
                @else
                    <!-- Area kosong untuk peta -->
                @endif
            </div>
        </div>

        <div class="boundary-info">
            <div class="boundary-table">
                <table>
                    <tr>
                        <td>UTARA</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_utara ?? '..............................' }}</td>
                    </tr>
                    <tr>
                        <td>TIMUR</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_timur ?? '..............................' }}</td>
                    </tr>
                    <tr>
                        <td>SELATAN</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_selatan ?? '..............................' }}</td>
                    </tr>
                    <tr>
                        <td>BARAT</td>
                        <td>:</td>
                        <td>{{ $spSipt->batas_barat ?? '..............................' }}</td>
                    </tr>
                </table>

                <div class="coordinate-section">
                    <h4>Titik Koordinat :</h4>
                    <table class="coordinate-table">
                        @if($spSipt->coordinates_array && count($spSipt->coordinates_array) > 0)
                            @foreach(collect($spSipt->coordinates_array)->take(4) as $index => $coord)
                            <tr>
                                <td>Titik - {{ ['I', 'II', 'III', 'IV'][$index] ?? ($index + 1) }}</td>
                                <td>:</td>
                                <td>LU = {{ $coord['lat'] ?? '' }} - BT = {{ $coord['lng'] ?? '' }}</td>
                            </tr>
                            @endforeach
                            @for($i = count($spSipt->coordinates_array); $i < 4; $i++)
                            <tr>
                                <td>Titik - {{ ['I', 'II', 'III', 'IV'][$i] }}</td>
                                <td>:</td>
                                <td>LU = - BT = </td>
                            </tr>
                            @endfor
                        @else
                            <tr>
                                <td>Titik - I</td>
                                <td>:</td>
                                <td>LU = - BT = </td>
                            </tr>
                            <tr>
                                <td>Titik - II</td>
                                <td>:</td>
                                <td>LU = - BT = </td>
                            </tr>
                            <tr>
                                <td>Titik - III</td>
                                <td>:</td>
                                <td>LU = - BT = </td>
                            </tr>
                            <tr>
                                <td>Titik - IV</td>
                                <td>:</td>
                                <td>LU = - BT = </td>
                            </tr>
                        @endif
                    </table>
                </div>
            </div>

            <div class="boundary-signature">
                <p>Yang membuat Sket/Gambar Tanah</p>
                <br><br><br><br>
                <p style="font-weight: bold; text-decoration: underline;">
                    ________________________________________
                </p>
                <p>NIP. ...............................................................  </p>
            </div>
        </div>
    </div>

    <script>
        // Auto print when page loads
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
